﻿# Clear Icon Cache – This script clears the Windows icon cache to fix incorrectly displayed or missing icons.

# Run ie4uinit to refresh system icons
Start-Process "ie4uinit.exe" -ArgumentList "-show" -Wait

# Terminate Windows Explorer
Stop-Process -Name "explorer" -Force

# Delete the main IconCache.db file
$iconCachePath = "$env:LOCALAPPDATA\IconCache.db"
if (Test-Path $iconCachePath) {
    Remove-Item $iconCachePath -Force -ErrorAction SilentlyContinue
}

# Delete all iconcache* files in the Explorer folder
$explorerCachePath = "$env:LOCALAPPDATA\Microsoft\Windows\Explorer\iconcache*"
Get-ChildItem -Path $explorerCachePath -Force -ErrorAction SilentlyContinue | Remove-Item -Force -ErrorAction SilentlyContinue

# Restart Windows Explorer
Start-Process "explorer.exe"
